import type { IncomingMessage } from 'http';
import type { DevBundler } from './router-utils/setup-dev-bundler';
import type { WorkerRequestHandler } from './types';
import { LRUCache } from './lru-cache';
import { type HmrMessageSentToBrowser, type NextJsHotReloaderInterface } from '../dev/hot-reloader-types';
/**
 * The DevBundlerService provides an interface to perform tasks with the
 * bundler while in development.
 */
export declare class DevBundlerService {
    private readonly bundler;
    private readonly handler;
    appIsrManifestInner: InstanceType<typeof LRUCache<boolean>>;
    close: NextJsHotReloaderInterface['close'];
    setCacheStatus: NextJsHotReloaderInterface['setCacheStatus'];
    setReactDebugChannel: NextJsHotReloaderInterface['setReactDebugChannel'];
    sendErrorsToBrowser: NextJsHotReloaderInterface['sendErrorsToBrowser'];
    constructor(bundler: DevBundler, handler: WorkerRequestHandler);
    ensurePage: typeof this.bundler.hotReloader.ensurePage;
    logErrorWithOriginalStack: (err: unknown, type?: "unhandledRejection" | "uncaughtException" | "warning" | "app-dir") => void;
    getFallbackErrorComponents(url?: string): Promise<void>;
    getCompilationError(page: string): Promise<any>;
    revalidate({ urlPath, revalidateHeaders, opts: revalidateOpts, }: {
        urlPath: string;
        revalidateHeaders: IncomingMessage['headers'];
        opts: any;
    }): Promise<{}>;
    get appIsrManifest(): Record<string, boolean>;
    setIsrStatus(key: string, value: boolean | undefined): void;
    sendHmrMessage(message: HmrMessageSentToBrowser): void;
}
